/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.speaker.DfpwmState;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.PauseAwareTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.phys.Vec3;

public abstract class SpeakerPeripheral
implements IPeripheral {
    public static final int SAMPLE_RATE = 48000;
    private final UUID source = UUID.randomUUID();
    private final AttachedComputerSet computers = new AttachedComputerSet();
    private long clock = 0L;
    private long lastPositionTime;
    @Nullable
    private SpeakerPosition lastPosition;
    private long lastPlayTime;
    private final List<PendingSound<Holder<SoundEvent>>> pendingNotes = new ArrayList<PendingSound<Holder<SoundEvent>>>();
    private final Object lock = new Object();
    private boolean shouldStop;
    @Nullable
    private PendingSound<ResourceLocation> pendingSound = null;
    @Nullable
    private DfpwmState dfpwmState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean shouldStop;
        DfpwmState dfpwmState;
        PendingSound<ResourceLocation> sound;
        ++this.clock;
        SpeakerPosition position = this.getPosition();
        Level level = position.level();
        Vec3 pos = position.position();
        if (level == null) {
            return;
        }
        MinecraftServer server = Nullability.assertNonNull(level.m_7654_());
        List<PendingSound<Holder<SoundEvent>>> list = this.pendingNotes;
        synchronized (list) {
            for (PendingSound<Holder<SoundEvent>> sound2 : this.pendingNotes) {
                this.lastPlayTime = this.clock;
                server.m_6846_().m_11241_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)(sound2.volume * 16.0f), level.m_46472_(), (Packet)new ClientboundSoundPacket((Holder)sound2.sound, SoundSource.RECORDS, pos.f_82479_, pos.f_82480_, pos.f_82481_, sound2.volume, sound2.pitch, level.m_213780_().m_188505_()));
            }
            this.pendingNotes.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            sound = this.pendingSound;
            dfpwmState = this.dfpwmState;
            this.pendingSound = null;
            shouldStop = this.shouldStop;
            if (shouldStop) {
                this.dfpwmState = null;
                dfpwmState = null;
                sound = null;
                this.shouldStop = false;
            }
        }
        if (shouldStop && this.lastPosition != null) {
            this.lastPosition = null;
            ServerNetworking.sendToAllPlayers(new SpeakerStopClientMessage(this.getSource()), server);
            return;
        }
        long now = PauseAwareTimer.getTime();
        if (sound != null) {
            this.lastPlayTime = this.clock;
            ServerNetworking.sendToAllAround(new SpeakerPlayClientMessage(this.getSource(), position, (ResourceLocation)sound.sound, sound.volume, sound.pitch), (ServerLevel)level, pos, sound.volume * 16.0f);
            this.syncedPosition(position);
        } else if (dfpwmState != null && dfpwmState.shouldSendPending(now)) {
            ServerNetworking.sendToAllTracking(new SpeakerAudioClientMessage(this.getSource(), position, dfpwmState.getVolume(), dfpwmState.pullPending(now)), level.m_46745_(BlockPos.m_274446_((Position)pos)));
            this.syncedPosition(position);
            this.computers.forEach(c -> c.queueEvent("speaker_audio_empty", c.getAttachmentName()));
        }
        if (this.lastPosition != null && this.clock - this.lastPositionTime >= 20L && !this.lastPosition.withinDistance(position, 0.1)) {
            ServerNetworking.sendToAllTracking(new SpeakerMoveClientMessage(this.getSource(), position), level.m_46745_(BlockPos.m_274446_((Position)pos)));
            this.syncedPosition(position);
        }
    }

    public abstract SpeakerPosition getPosition();

    public UUID getSource() {
        return this.source;
    }

    public boolean madeSound() {
        DfpwmState state = this.dfpwmState;
        return this.clock - this.lastPlayTime <= 20L || state != null && state.isPlaying();
    }

    @Override
    public String getType() {
        return "speaker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playNote(ILuaContext context, String instrumentA, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)SpeakerPeripheral.clampVolume(LuaValues.checkFinite(1, volumeA.orElse(1.0)));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        NoteBlockInstrument instrument = null;
        for (NoteBlockInstrument testInstrument : NoteBlockInstrument.values()) {
            if (!testInstrument.m_7912_().equalsIgnoreCase(instrumentA)) continue;
            instrument = testInstrument;
            break;
        }
        if (instrument == null) {
            throw new LuaException("Invalid instrument, \"" + String.valueOf(instrument) + "\"!");
        }
        List<PendingSound<Holder<SoundEvent>>> list = this.pendingNotes;
        synchronized (list) {
            if (this.pendingNotes.size() >= Config.maxNotesPerTick) {
                return false;
            }
            this.pendingNotes.add(new PendingSound<Holder>(instrument.m_263188_(), volume, (float)Math.pow(2.0, ((double)pitch - 12.0) / 12.0)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playSound(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)SpeakerPeripheral.clampVolume(LuaValues.checkFinite(1, volumeA.orElse(1.0)));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        ResourceLocation identifier = ResourceLocation.m_135820_((String)name);
        if (identifier == null) {
            throw new LuaException("Malformed sound name '" + name + "' ");
        }
        SoundEvent soundEvent = (SoundEvent)PlatformHelper.get().tryGetRegistryObject(Registries.f_256840_, identifier);
        if (soundEvent != null && RecordItem.m_43040_((SoundEvent)soundEvent) != null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingSound != null || this.dfpwmState != null && this.dfpwmState.isPlaying()) {
                return false;
            }
            this.dfpwmState = null;
            this.pendingSound = new PendingSound<ResourceLocation>(identifier, volume, pitch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(unsafe=true)
    public final boolean playAudio(ILuaContext context, LuaTable<?, ?> audio, Optional<Double> volume) throws LuaException {
        DfpwmState state;
        LuaValues.checkFinite(1, volume.orElse(0.0));
        int length = audio.length();
        if (length <= 0) {
            throw new LuaException("Cannot play empty audio");
        }
        if (length > 131072) {
            throw new LuaException("Audio data is too large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dfpwmState == null || !this.dfpwmState.isPlaying()) {
                this.dfpwmState = new DfpwmState();
            }
            state = this.dfpwmState;
            this.pendingSound = null;
        }
        return state.pushBuffer(audio, length, volume);
    }

    @LuaFunction
    public final void stop() {
        this.shouldStop = true;
    }

    private void syncedPosition(SpeakerPosition position) {
        this.lastPosition = position;
        this.lastPositionTime = this.clock;
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    static double clampVolume(double volume) {
        return Mth.m_14008_((double)volume, (double)0.0, (double)3.0);
    }

    private record PendingSound<T>(T sound, float volume, float pitch) {
    }
}

