/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.Expander;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.MonitorState;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorBlockEntity
extends BlockEntity {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorBlockEntity.class);
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private final boolean advanced;
    @Nullable
    private ServerMonitor serverMonitor;
    @Nullable
    private ClientMonitor clientMonitor;
    @Nullable
    private MonitorPeripheral peripheral;
    private final AttachedComputerSet computers = new AttachedComputerSet();
    private boolean needsUpdate = false;
    private boolean needsValidating = false;
    boolean enqueued;
    @Nullable
    TerminalState cached;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;
    @Nullable
    private BlockPos bbPos;
    @Nullable
    private BlockState bbState;
    private int bbX;
    private int bbY;
    private int bbWidth;
    private int bbHeight;
    @Nullable
    private AABB boundingBox;
    TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public MonitorBlockEntity(BlockEntityType<? extends MonitorBlockEntity> type, BlockPos pos, BlockState state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
    }

    public void m_6339_() {
        super.m_6339_();
        this.needsValidating = true;
        TickScheduler.schedule(this.tickToken);
    }

    void destroy() {
        if (!this.m_58904_().f_46443_) {
            this.contractNeighbours();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.clientMonitor != null) {
            this.clientMonitor.destroy();
        }
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_(NBT_X, this.xIndex);
        tag.m_128405_(NBT_Y, this.yIndex);
        tag.m_128405_(NBT_WIDTH, this.width);
        tag.m_128405_(NBT_HEIGHT, this.height);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        this.xIndex = nbt.m_128451_(NBT_X);
        this.yIndex = nbt.m_128451_(NBT_Y);
        this.width = nbt.m_128451_(NBT_WIDTH);
        this.height = nbt.m_128451_(NBT_HEIGHT);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.onClientLoad(oldXIndex, oldYIndex);
        }
    }

    void blockTick() {
        if (this.needsValidating) {
            this.needsValidating = false;
            this.validate();
        }
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.expand();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        if (this.serverMonitor.pollResized()) {
            this.eachComputer(c -> c.queueEvent("monitor_resize", c.getAttachmentName()));
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            MonitorWatcher.enqueue(this);
        }
    }

    @Nullable
    @VisibleForTesting
    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        MonitorBlockEntity origin = this.getOrigin();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        BlockEntity te = this.m_58904_().m_7702_(this.toWorldPos(0, 0));
        if (!(te instanceof MonitorBlockEntity)) {
            return null;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        this.serverMonitor = monitor.createServerMonitor();
        return this.serverMonitor;
    }

    private void createServerTerminal() {
        ServerMonitor monitor = this.createServerMonitor();
        if (monitor != null && monitor.getTerminal() == null) {
            monitor.rebuild();
        }
    }

    @Nullable
    public ClientMonitor getOriginClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        MonitorBlockEntity origin = this.getOrigin();
        return origin == null ? null : origin.clientMonitor;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_(NBT_X, this.xIndex);
        nbt.m_128405_(NBT_Y, this.yIndex);
        nbt.m_128405_(NBT_WIDTH, this.width);
        nbt.m_128405_(NBT_HEIGHT, this.height);
        return nbt;
    }

    private void onClientLoad(int oldXIndex, int oldYIndex) {
        if ((oldXIndex != this.xIndex || oldYIndex != this.yIndex) && this.clientMonitor != null) {
            this.clientMonitor.destroy();
            this.clientMonitor = null;
        }
        if (this.xIndex == 0 && this.yIndex == 0 && this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
    }

    public final void read(@Nullable TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            LOG.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.m_58899_());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(MonitorBlock.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1))), 2);
    }

    public Direction getDirection() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)MonitorBlock.FACING) ? (Direction)state.m_61143_((Property)MonitorBlock.FACING) : Direction.NORTH;
    }

    public Direction getOrientation() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)MonitorBlock.ORIENTATION) ? (Direction)state.m_61143_((Property)MonitorBlock.ORIENTATION) : Direction.NORTH;
    }

    public Direction getFront() {
        Direction orientation = this.getOrientation();
        return orientation == Direction.NORTH ? this.getDirection() : orientation;
    }

    public Direction getRight() {
        return this.getDirection().m_122428_();
    }

    public Direction getDown() {
        Direction orientation = this.getOrientation();
        if (orientation == Direction.NORTH) {
            return Direction.UP;
        }
        return orientation == Direction.DOWN ? this.getDirection() : this.getDirection().m_122424_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    boolean isCompatible(MonitorBlockEntity other) {
        return this.advanced == other.advanced && this.getOrientation() == other.getOrientation() && this.getDirection() == other.getDirection();
    }

    private MonitorState getLoadedMonitor(int x, int y) {
        if (x == this.xIndex && y == this.yIndex) {
            return MonitorState.present(this);
        }
        BlockPos pos = this.toWorldPos(x, y);
        Level world = this.m_58904_();
        if (world == null || !world.m_46749_(pos)) {
            return MonitorState.UNLOADED;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof MonitorBlockEntity)) {
            return MonitorState.MISSING;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
        return this.isCompatible(monitor) ? MonitorState.present(monitor) : MonitorState.MISSING;
    }

    @Nullable
    private MonitorBlockEntity getOrigin() {
        return this.getLoadedMonitor(0, 0).getMonitor();
    }

    BlockPos toWorldPos(int x, int y) {
        if (this.xIndex == x && this.yIndex == y) {
            return this.m_58899_();
        }
        return this.m_58899_().m_5484_(this.getRight(), -this.xIndex + x).m_5484_(this.getDown(), -this.yIndex + y);
    }

    void resize(int width, int height) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
            }
            this.serverMonitor.rebuild();
        } else if (this.serverMonitor != null) {
            this.serverMonitor.reset();
        }
        BlockPos pos = this.m_58899_();
        Direction down = this.getDown();
        Direction right = this.getRight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                MonitorBlockEntity monitor;
                BlockEntity other = this.m_58904_().m_7702_(pos.m_5484_(right, x).m_5484_(down, y));
                if (!(other instanceof MonitorBlockEntity) || !this.isCompatible(monitor = (MonitorBlockEntity)other)) continue;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.needsValidating = false;
                monitor.needsUpdate = false;
                monitor.updateBlockState();
                BlockEntityHelpers.updateBlock(monitor);
            }
        }
        this.assertInvariant();
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void expand() {
        MonitorBlockEntity monitor = this.getOrigin();
        if (monitor != null && monitor.xIndex == 0 && monitor.yIndex == 0) {
            new Expander(monitor).expand();
        }
    }

    private void contractNeighbours() {
        if (this.width == 1 && this.height == 1) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Direction down = this.getDown();
        Direction right = this.getRight();
        BlockPos origin = this.toWorldPos(0, 0);
        MonitorBlockEntity toLeft = null;
        MonitorBlockEntity toAbove = null;
        MonitorBlockEntity toRight = null;
        MonitorBlockEntity toBelow = null;
        if (this.xIndex > 0) {
            toLeft = this.tryResizeAt(pos.m_5484_(right, -this.xIndex), this.xIndex, 1);
        }
        if (this.yIndex > 0) {
            toAbove = this.tryResizeAt(origin, this.width, this.yIndex);
        }
        if (this.xIndex < this.width - 1) {
            toRight = this.tryResizeAt(pos.m_5484_(right, 1), this.width - this.xIndex - 1, 1);
        }
        if (this.yIndex < this.height - 1) {
            toBelow = this.tryResizeAt(origin.m_5484_(down, this.yIndex + 1), this.width, this.height - this.yIndex - 1);
        }
        if (toLeft != null) {
            toLeft.expand();
        }
        if (toAbove != null) {
            toAbove.expand();
        }
        if (toRight != null) {
            toRight.expand();
        }
        if (toBelow != null) {
            toBelow.expand();
        }
    }

    @Nullable
    private MonitorBlockEntity tryResizeAt(BlockPos pos, int width, int height) {
        MonitorBlockEntity monitor;
        BlockEntity tile = this.m_58904_().m_7702_(pos);
        if (tile instanceof MonitorBlockEntity && this.isCompatible(monitor = (MonitorBlockEntity)tile)) {
            monitor.resize(width, height);
            return monitor;
        }
        return null;
    }

    private boolean checkMonitorAt(int xIndex, int yIndex) {
        MonitorState state = this.getLoadedMonitor(xIndex, yIndex);
        if (state.isMissing()) {
            return false;
        }
        MonitorBlockEntity monitor = state.getMonitor();
        if (monitor == null) {
            return true;
        }
        return monitor.xIndex == xIndex && monitor.yIndex == yIndex && monitor.width == this.width && monitor.height == this.height;
    }

    private void validate() {
        if (this.xIndex == 0 && this.yIndex == 0 && this.width == 1 && this.height == 1) {
            return;
        }
        if (this.xIndex >= 0 && this.xIndex <= this.width && this.width > 0 && this.width <= Config.monitorWidth && this.yIndex >= 0 && this.yIndex <= this.height && this.height > 0 && this.height <= Config.monitorHeight && this.checkMonitorAt(0, 0) && this.checkMonitorAt(0, this.height - 1) && this.checkMonitorAt(this.width - 1, 0) && this.checkMonitorAt(this.width - 1, this.height - 1)) {
            return;
        }
        LOG.warn("Monitor is malformed, resetting to 1x1.");
        this.resize(1, 1);
        this.needsUpdate = true;
    }

    void monitorTouched(float xPos, float yPos, float zPos) {
        if (!this.advanced) {
            return;
        }
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x() > (double)this.width - 0.125 || (double)pair.y() > (double)this.height - 0.125 || (double)pair.x() < 0.125 || (double)pair.y() < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null) {
            return;
        }
        NetworkedTerminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x() - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y() - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        this.eachComputer(c -> c.queueEvent("monitor_touch", c.getAttachmentName(), xCharPos, yCharPos));
    }

    private void eachComputer(Consumer<IComputerAccess> fun) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                monitor.computers.forEach(fun);
            }
        }
    }

    public IPeripheral peripheral() {
        this.createServerTerminal();
        MonitorPeripheral peripheral = this.peripheral != null ? this.peripheral : (this.peripheral = new MonitorPeripheral(this));
        this.assertInvariant();
        return peripheral;
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public AABB getRenderBoundingBox() {
        if (this.boundingBox != null && this.m_58900_().equals(this.bbState) && this.m_58899_().equals((Object)this.bbPos) && this.xIndex == this.bbX && this.yIndex == this.bbY && this.width == this.bbWidth && this.height == this.bbHeight) {
            return this.boundingBox;
        }
        this.bbState = this.m_58900_();
        this.bbPos = this.m_58899_();
        this.bbX = this.xIndex;
        this.bbY = this.yIndex;
        this.bbWidth = this.width;
        this.bbHeight = this.height;
        BlockPos startPos = this.toWorldPos(0, 0);
        BlockPos endPos = this.toWorldPos(this.width, this.height);
        this.boundingBox = new AABB((double)Math.min(startPos.m_123341_(), endPos.m_123341_()), (double)Math.min(startPos.m_123342_(), endPos.m_123342_()), (double)Math.min(startPos.m_123343_(), endPos.m_123343_()), (double)(Math.max(startPos.m_123341_(), endPos.m_123341_()) + 1), (double)(Math.max(startPos.m_123342_(), endPos.m_123342_()) + 1), (double)(Math.max(startPos.m_123343_(), endPos.m_123343_()) + 1));
        return this.boundingBox;
    }

    private void assertInvariant() {
        assert (this.checkInvariants()) : "Monitor invariants failed. See logs.";
    }

    private boolean checkInvariants() {
        LOG.debug("Checking monitor invariants at {}", (Object)this.m_58899_());
        boolean okay = true;
        if (this.width <= 0 || this.height <= 0) {
            okay = false;
            LOG.error("Monitor {} has non-positive of {}x{}", new Object[]{this.m_58899_(), this.width, this.height});
        }
        boolean hasPeripheral = false;
        MonitorBlockEntity origin = this.getOrigin();
        ServerMonitor serverMonitor = origin != null ? origin.serverMonitor : this.serverMonitor;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                hasPeripheral |= monitor.peripheral != null;
                if (monitor.serverMonitor != null && monitor.serverMonitor != serverMonitor) {
                    okay = false;
                    LOG.error("Monitor {} expected to be have serverMonitor={}, but was {}", new Object[]{monitor.m_58899_(), serverMonitor, monitor.serverMonitor});
                }
                if (monitor.xIndex != x || monitor.yIndex != y) {
                    okay = false;
                    LOG.error("Monitor {} expected to be at {},{}, but believes it is {},{}", new Object[]{monitor.m_58899_(), x, y, monitor.xIndex, monitor.yIndex});
                }
                if (monitor.width != this.width || monitor.height != this.height) {
                    okay = false;
                    LOG.error("Monitor {} expected to be size {},{}, but believes it is {},{}", new Object[]{monitor.m_58899_(), this.width, this.height, monitor.width, monitor.height});
                }
                BlockState expectedState = (BlockState)this.m_58900_().m_61124_(MonitorBlock.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(y < this.height - 1, y > 0, x > 0, x < this.width - 1)));
                if (monitor.m_58900_() == expectedState) continue;
                okay = false;
                LOG.error("Monitor {} expected to have state {}, but has state {}", new Object[]{monitor.m_58900_(), expectedState, monitor.m_58900_()});
            }
        }
        if (hasPeripheral != (serverMonitor != null && serverMonitor.getTerminal() != null)) {
            okay = false;
            LOG.error("Peripheral is {}, but serverMonitor={} and serverMonitor.terminal={}", new Object[]{hasPeripheral, serverMonitor, serverMonitor == null ? null : serverMonitor.getTerminal()});
        }
        return okay;
    }
}

